/****** Object:  StoredProcedure [dbo].[GCP_VND_ActualizaDocumentoVenda]    Script Date: 19/07/2024 12:58:58 ******/
DROP PROCEDURE [dbo].[GCP_VND_ActualizaDocumentoVenda]
GO

/****** Object:  StoredProcedure [dbo].[GCP_VND_ActualizaDocumentoVenda]    Script Date: 19/07/2024 12:58:58 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE PROCEDURE [dbo].[GCP_VND_ActualizaDocumentoVenda] 
                 @strXMLCabec           AS NVARCHAR(MAX), 
				 @strXMLLinhas          AS NVARCHAR(MAX), 
				 @strXMLLinhasRemovidas AS NVARCHAR(MAX), 
				 @strXMLLinhasNSerie    AS NVARCHAR(MAX), 
				 @strXMLResiduos        AS NVARCHAR(MAX), 
				 @strXMLHistorico       AS NVARCHAR(MAX), 
				 @strXMLIEC             AS NVARCHAR(MAX), 
				 @bitDocNovo            AS BIT, 
				 @uidIDCabecDoc         AS UNIQUEIDENTIFIER, 
				 @strFilial             AS VARCHAR(3), 
				 @strTipoDoc            AS VARCHAR(5), 
				 @strSerie              AS VARCHAR(5), 
				 @intNumDoc             AS INT, 
				 @strSeccao             AS VARCHAR(2), 
				 @datDataDoc            AS DATETIME, 
				 @uidIDEstorno          AS UNIQUEIDENTIFIER, 
				 @strCondPag            AS VARCHAR(2), 
				 @strFluxo              AS VARCHAR(3), 
				 @strTipoEntidade       AS VARCHAR(1), 
				 @strEntidade           AS VARCHAR(12), 
				 @fltTotalDocumento     AS FLOAT, 
				 @fltCambio             AS FLOAT, 
				 @strMoedaStk           AS VARCHAR(3), 
				 @fltCambioMStk         AS FLOAT, 
				 @strReferencia         AS VARCHAR(60), 
				 @bitFechado            AS BIT, 
				 @bitAnulado            AS BIT, 
				 @bitLote               AS BIT
AS
DECLARE @intLinhasNSerie                   INT 
DECLARE @intResiduos                       INT 
DECLARE @intIEC							   INT
DECLARE @intCabec   					   INT
DECLARE @bitTrataNumerosSerie              BIT
DECLARE @bitTrataResiduos                  BIT
DECLARE @bitTrataIEC                       BIT
	
SET NOCOUNT ON 
SET ANSI_WARNINGS OFF
-- Remove as tabelas temporárias
EXEC STD_DropTempTable '#TmpCabec'
EXEC STD_DropTempTable '#TmpLinhas'
-- Tabela de Erros 
IF NOT EXISTS (SELECT ID FROM tempdb..sysobjects WHERE  ID = Object_ID('tempdb..#TmpErros') AND Type = 'U') 
	CREATE TABLE [dbo].[#TmpErros] ([Tipo] VARCHAR(1), [ID] INT, [Mensagem] VARCHAR(512), [Parametro1] VARCHAR(512), [Parametro2] VARCHAR(512), [Parametro3] VARCHAR(512), [Parametro4] VARCHAR(512), [Parametro5] VARCHAR(512)) 
ELSE 
	DELETE FROM [dbo].[#TmpErros]
	
--Cabeçalhos dos documentos
EXEC sp_xml_preparedocument @intCabec OUTPUT, @strXMLCabec
	
SELECT * 
INTO [dbo].[#TmpCabec] 
FROM OPENXML (@intCabec, 'Documento/CD') 
	WITH 
	(	  [VS] 		VARCHAR(5)
		, [ID] 		UNIQUEIDENTIFIER
		, [FIL] 	NVARCHAR(3)
		, [TDO] 	NVARCHAR(5)
		, [TFI] 	NVARCHAR(5)
		, [SE] 		NVARCHAR(5)
		, [ND] 		INT
		, [SC] 		NVARCHAR(2)
		, [RI] 		NVARCHAR(1)
		, [LOP] 	VARCHAR(2)
		, [DT] 		DATETIME
		, [DTV] 	DATETIME
		, [MO] 		NVARCHAR(3)
		, [CMB] 	FLOAT
		, [CMBMB] 	FLOAT
		, [CMBMA] 	FLOAT
		, [MUEM] 	BIT
		, [AR] 		SMALLINT
		, [ARIVA] 	SMALLINT
		, [FD] 		NVARCHAR(3)
		, [RQ] 		NVARCHAR(60)
		, [RF] 		NVARCHAR(60)
		, [GR] 		VARCHAR(30)
		, [OR] 		VARCHAR(15)
		, [TE] 		NVARCHAR(1)
		, [EN] 		NVARCHAR(12)
		, [DE] 		REAL
		, [NC] 		NVARCHAR(20)
		, [NM] 		NVARCHAR(MAX)
		, [MD] 		NVARCHAR(MAX)
		, [MD2] 	NVARCHAR(MAX)
		, [LO] 		NVARCHAR(MAX)
		, [CP] 		NVARCHAR(15)
		, [CPL] 	NVARCHAR(50)
		, [DTO] 	VARCHAR(2)
		, [CPG] 	NVARCHAR(2)
		, [DPG] 	REAL
		, [MPG] 	NVARCHAR(5)
		, [ZO] 		NVARCHAR(2)
		, [RC] 		NVARCHAR(3)
		, [RS] 		NVARCHAR(25)
		, [ME] 		NVARCHAR(5)
		, [TM] 		FLOAT
		, [TD] 		FLOAT
		, [TO] 		FLOAT
		, [TI] 		FLOAT
		, [TRE] 	FLOAT
		, [TOP] 	NVARCHAR(2)
		, [ACBL] 	SMALLINT
		, [DIA] 	NVARCHAR(5)
		, [NDIA] 	INT
		, [PR] 		FLOAT
		, [TR] 		FLOAT
		, [TRG] 	FLOAT
		, [IDGDOC] 	UNIQUEIDENTIFIER
		, [OID] 	UNIQUEIDENTIFIER
		, [WBSI] 	NVARCHAR(100)
		, [IDCE] 	UNIQUEIDENTIFIER
		, [DTUA] 	DATETIME
		, [DO] 		NTEXT
		, [OB] 		NTEXT
		, [IDCBL] 	UNIQUEIDENTIFIER
		, [IDDC] 	UNIQUEIDENTIFIER
		, [OPOS] 	BIT
		, [IDB2B] 	UNIQUEIDENTIFIER
		, [IDA] 	UNIQUEIDENTIFIER
		, [CD] 		VARCHAR(5)
		, [DEIL] 	NVARCHAR(20)
		, [TX] 		FLOAT
		, [UT] 		NVARCHAR(20)
		, [PO] 		NVARCHAR(3)
		, [TL] 		VARCHAR(3)
		, [TEF] 	NVARCHAR(1)
		, [ENF] 	NVARCHAR(12)
		, [NMF] 	NVARCHAR(MAX)
		, [MDF] 	NVARCHAR(MAX)
		, [MD2F] 	NVARCHAR(MAX)
		, [LOF] 	NVARCHAR(MAX)
		, [CPF] 	NVARCHAR(15)
		, [CPLF] 	NVARCHAR(50)
		, [NCF] 	NVARCHAR(20)
		, [DTOF] 	VARCHAR(2)
		, [TIEC] 	FLOAT
		, [GPPL] 	BIT
		, [ASSD] 	NVARCHAR(255)
		, [VASSD] 	NVARCHAR(20)
		, [RIVA] 	SMALLINT 
		, [ESF] 	SMALLINT
		, [DG] 		DATETIME
		, [IDO] 	UNIQUEIDENTIFIER
		, [NPR]	 	SMALLINT
		, [B2BTT] 	BIT			
		, [B2BENG] 	BIT			
		, [PAIS] 	NVARCHAR(2)
		, [PFAC] 	NVARCHAR(2)
		, [NREF] 	VARCHAR(50)
		, [NREFTIPO] 	VARCHAR(50)
		, [NREFSERIE] 	VARCHAR(50)
		, [CERT] 	VARCHAR(50)		
		, [CERTR] 	VARCHAR(50)		
		, [CADD]	BIT
		, [IDORI] 	UNIQUEIDENTIFIER
		, [MORI] 	NVARCHAR(1)		
		/* Carga/Descarga/Entrega */
		--Carga
		, [LC] 			NVARCHAR(50)
		, [DTHC] 		DATETIME		 
		, [MT] 			NVARCHAR(25)
		, [MCAR] 		NVARCHAR(MAX)
		, [M2CAR] 		NVARCHAR(MAX)
		, [LCAR] 		NVARCHAR(MAX)
		, [CPCAR] 		NVARCHAR(15)
		, [CPLCAR] 		NVARCHAR(50)
		, [DTOCAR] 		VARCHAR(2)
		, [PAICAR] 		NVARCHAR(2)
		--Descarga
		, [LD] 			NVARCHAR(50)
		, [DTHD] 		DATETIME 
		, [END] 		NVARCHAR(12)
		--Entrega
		, [UMA] 		BIT
		, [MA] 			NVARCHAR(10)
		, [TEEN] 		NVARCHAR(1)
		, [EEN] 		NVARCHAR(12)
		, [NEN] 		NVARCHAR(MAX)
		, [MEN] 		NVARCHAR(MAX)
		, [M2EN] 		NVARCHAR(MAX)
		, [LEN] 		NVARCHAR(MAX)
		, [CPEN] 		NVARCHAR(15)
		, [CPLEN] 		NVARCHAR(50)
		, [DTOEN] 		VARCHAR(2)
		, [PAIEN] 		NVARCHAR(2)
		, [CAE]			VARCHAR(15)
		, [RES]			BIT
		, [IDREG]		UNIQUEIDENTIFIER
		, [TIS]			FLOAT
		, [TIC]			BIT
		, [DOC] 		NVARCHAR(50)
		, [IDC]         UNIQUEIDENTIFIER
		, [TTC]			NVARCHAR(3)
		, [DI] 		    BIT
		, [MC] 		    SMALLINT
		, [ES] 		    NVARCHAR(1)
		, [AN] 		    BIT
		, [FE] 		    BIT
		, [ATCID] 	    NVARCHAR(200)
		, [CMAN] 	    BIT
		, [TDOC] 	    FLOAT
		, [TFREE] 	    BIT
		, [TFPA] 	    NVARCHAR(200)
		, [TFVC] 	    FLOAT
		, [TFIVA] 	    FLOAT
		, [TFVD] 	    FLOAT
		, [DTNC]		DATETIME
		, [TFTE]		NVARCHAR(1)
		, [TFB]			NVARCHAR(12)
		, [TFPEP] 	    NVARCHAR(2)
		, [PC] 			FLOAT
		, [PAYID] 	    NVARCHAR(50)
		, [OCD]			BIT				-- Oculta Carga Descarga
		, [MEMI]		NVARCHAR(3)		-- Motivo Emissão documento
		, [DMEMI]		NVARCHAR(100)	-- Descrição do Motivo Emissão documento
		, [POSVE] 		FLOAT			-- Valor Entregue POS
		, [SCON]		BIT
				, [CDU_CABVAR1] [nvarchar] (15)				, [CDU_CABVAR1ENC] [nvarchar] (15)				, [CDU_CABVAR2] [nvarchar] (15)				, [CDU_CABVAR2ENC] [nvarchar] (15)				, [CDU_CABVAR3] [nvarchar] (15)				, [CDU_CABVAR3ENC] [nvarchar] (15)				, [CDU_CABVAR4] [nvarchar] (15)				, [CDU_CABVAR4ENC] [nvarchar] (15)				, [CDU_CABVAR5] [nvarchar] (15)				, [CDU_CABVAR5ENC] [nvarchar] (15)				, [CDU_CODIGOLOCALIZACAO] [varchar] (13)				, [CDU_DATA] [datetime]				, [CDU_PROID] [int]				, [CDU_CABEC] [nvarchar] (10)				, [CDU_NOMEVENDEDOR] [nvarchar] (10)				, [CDU_TROCO] [nvarchar] (10)				, [CDU_TTE_DATAREFFACTURAORIG] [nvarchar] (30)				, [CDU_CATALOGUEPURPOSE] [varchar] (13)				, [CDU_CODFORNECEDOR] [varchar] (13)				, [CDU_NUMEROALTERACAOJM] [varchar] (20)				, [CDU_ORDEMALTERACAOJM] [int]				, [CDU_DATAMAXIMAENTREGA] [nvarchar] (20)				, [CDU_DATAALTERACAOJM] [datetime]				, [CDU_REFFACTURAORIG] [nvarchar] (30)				, [CDU_REFGUIAREMESSA] [nvarchar] (30)				, [CDU_TTE_ORDEMALTERACAO] [int]				, [CDU_TTE_DATAALTERACAO] [nvarchar] (50)				, [CDU_TTE_NUMEROALTERACAO] [nvarchar] (50)				, [CDU_CODJMLOCALENTREGA] [varchar] (20)				, [CDU_NOMEENTREGA] [varchar] (50)				, [CDU_MORADAENTREGA] [varchar] (50)				, [CDU_CODPOSTALENTREGA] [varchar] (15)				, [CDU_LOCALCODPOSTALENTREGA] [varchar] (50)				, [CDU_TIPOFACTURAJM] [varchar] (10)				, [CDU_NUMDOCDEVOLUCAO] [varchar] (20)				, [CDU_DATADISPONIB] [datetime]				, [CDU_IVADEVIDOADQ] [bit]				, [CDU_GENERALNOTEFREETEXT] [varchar] (50)				, [CDU_IVAART1] [bit]				, [CDU_NUNOC] [nvarchar] (10)				, [CDU_1] [nvarchar] (10)				, [CDU_2] [nvarchar] (10)				, [CDU_3] [nvarchar] (10)				, [CDU_4] [nvarchar] (10)				, [CDU_5] [nvarchar] (10)
) XCD
-- Números de série
	CREATE TABLE [dbo].[#TmpLinhasNumSerie] ([M] NVARCHAR(1), [IDL] UNIQUEIDENTIFIER, [NS] NVARCHAR(30), [IDNS] UNIQUEIDENTIFIER, [MA] BIT) 
		
SET @bitTrataNumerosSerie = 0
IF ISNULL(DATALENGTH(@strXMLLinhasNSerie),0) > 0
BEGIN
	SET @bitTrataNumerosSerie = 1
	EXEC sp_xml_preparedocument @intLinhasNSerie OUTPUT, @strXMLLinhasNSerie
	-- Temporária para validação/manipulação dos números de série 
	INSERT INTO [dbo].[#TmpLinhasNumSerie]
		SELECT [M], [IDL], [NS],[IDNS], [MA] 
	FROM OPENXML (@intLinhasNSerie, 'Documento/LNS') 
			WITH([M] NVARCHAR(1), [IDL] UNIQUEIDENTIFIER, [NS] NVARCHAR(30), [IDNS] UNIQUEIDENTIFIER, [MA] BIT) 
	EXEC sp_xml_removedocument @intLinhasNSerie
END
-- Temporária para validação/manipulação dos resíduos
SET @bitTrataResiduos = 0
IF ISNULL(DATALENGTH(@strXMLResiduos),0) > 0
BEGIN
	SET @bitTrataResiduos = 1
	EXEC sp_xml_preparedocument @intResiduos OUTPUT, @strXMLResiduos
	SELECT [ID], [IDL], [EC], [RE], [M], [CI], [TI], [QT], [TP], [CT], [UN], [QTR]
	INTO [dbo].[#TmpResiduos]
	FROM OPENXML (@intResiduos, 'Documento/RES') 
		WITH([ID] UNIQUEIDENTIFIER, [IDL] UNIQUEIDENTIFIER, [EC] FLOAT, [RE] VARCHAR(20), [M] VARCHAR(1), [CI] VARCHAR(2), [TI] FLOAT, [QT] FLOAT, [TP] VARCHAR(15), [CT] NVARCHAR(20), [UN] NVARCHAR(5), [QTR] FLOAT) 
	EXEC sp_xml_removedocument @intResiduos
END
	
-- Temporária para validação/manipulação das linhas de IEC
SET @bitTrataIEC = 0
IF ISNULL(DATALENGTH(@strXMLIEC),0) > 0
BEGIN
	SET @bitTrataIEC = 1
	EXEC sp_xml_preparedocument @intIEC OUTPUT, @strXMLIEC
	SELECT 	[ID]
		, 	[IDL]
		, 	[VIEC]
		, 	[M]
		, 	[CI]
		, 	[TI]
		, 	[QT]
		, 	[CIEC]
		, 	[CDIEC]
		, 	[CT]
		, 	[EIEC]
		, 	[UN]
		, 	[CEMB]
		, 	[PLIQ]
		, 	[PBR]
		, 	[TIEC]
		,	[Arm] 
		, 	[TOIEC]
		, 	[NumOpIEC]
		, 	[EFIEC]
	INTO [dbo].[#TmpIEC]
	FROM OPENXML (@intIEC, 'Documento/IEC') 
		WITH(	[ID] 	UNIQUEIDENTIFIER
			, 	[IDL] 	UNIQUEIDENTIFIER
			, 	[VIEC] 	FLOAT
			, 	[M] 	VARCHAR(1)
			, 	[CI] 	VARCHAR(2)
			, 	[TI] 	FLOAT
			, 	[QT] 	FLOAT
			, 	[CIEC] 	NVARCHAR(10)
			, 	[CDIEC] NVARCHAR(5)
			, 	[CT] 	NVARCHAR(14) 
			,	[EIEC] 	NVARCHAR(2)
			, 	[UN] 	NVARCHAR(5)
			,	[CEMB] 	FLOAT
			, 	[PLIQ] 	FLOAT
			, 	[PBR] 	FLOAT
			, 	[TIEC] 	FLOAT
			, 	[Arm] NVARCHAR(5)
			, 	[TOIEC] tinyint
			, 	[NumOpIEC] NVARCHAR(15)
			, 	[EFIEC] NVARCHAR(20)
			) 
	EXEC sp_xml_removedocument @intIEC
END
EXEC [dbo].[GCP_VND_ActualizaDocumentoVendaExec] @strXMLCabec, @strXMLLinhas, @strXMLLinhasRemovidas, @strXMLLinhasNSerie, @strXMLResiduos, @strXMLHistorico, @strXMLIEC, @bitDocNovo, @uidIDCabecDoc, @strFilial, @strTipoDoc, @strSerie, @intNumDoc, @strSeccao, @datDataDoc, @uidIDEstorno, @strCondPag, @strFluxo, @strTipoEntidade, @strEntidade, @fltTotalDocumento, @fltCambio, @strMoedaStk, @fltCambioMStk, @strReferencia, @bitFechado, @bitAnulado, @bitLote, @intCabec, @bitTrataNumerosSerie, @bitTrataResiduos, @bitTrataIEC
EXEC sp_xml_removedocument @intCabec
IF EXISTS (SELECT [ID] FROM tempdb..sysobjects WHERE [ID] = Object_ID('tempdb..#TmpErros') AND Type = 'U') 
	SELECT [Tipo], [ID], [Mensagem], [Parametro1], [Parametro2], [Parametro3], [Parametro4], [Parametro5] FROM [dbo].[#TmpErros]
GO


